<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/GestoreTabella.php";
    include "../gUtil/Ricerca.php";
    include "../classi/Categoria.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/Tabella.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    $impostazioniLingue = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue", 1);
            
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $categoria  = new Categoria($geecomDb, filter_input(INPUT_GET, "id"));
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $categoria  = new Categoria($geecomDb, filter_input(INPUT_POST, "id"));
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomCMS  = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'crea':
            $titoloPagina = filter_input(INPUT_POST,"titoloPagina",FILTER_SANITIZE_ADD_SLASHES);
            $metaDescrizione = filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES);
            $descrizione     = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING);   
            $tipo            = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING);
            $categoriaMadre  = filter_input(INPUT_POST,"categoriaMadre",FILTER_SANITIZE_NUMBER_INT);
            
            $categoria->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $categoria->setTitoloPagina($titoloPagina);
            $categoria->setTipo($tipo);
            $categoria->setLingua($impostazioniLingue["linguaPrincipale"]);
            $categoria->setCategoriaMadre($categoriaMadre);
            $categoria->setElementiPerPagina(filter_input(INPUT_POST,"numeroArticoliPerPagina",FILTER_SANITIZE_NUMBER_INT));
            $categoria->setMetaDescrizione($metaDescrizione);
            $categoria->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $categoria->setOrdinamento(filter_input(INPUT_POST,"ordinamento",FILTER_SANITIZE_STRING));
            
            $query = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre=$categoriaMadre ORDER BY posizione DESC LIMIT 1";
            $risQuery = $geecomDb->eseguiQueryLettura($query);
            if($risQuery->num_rows>0) {
                $datiCategoria = $risQuery->fetch_assoc();
                $categoria->setPosizione($datiCategoria["posizione"]+1);
            }
            else {            
                $categoria->setPosizione(1);
            }
            
            // calcolo puntegigo SEO
            $datiCategoria = array("titoloPagina"=>$titoloPagina,"metaDescrizione"=>$metaDescrizione,"descrizione"=>$descrizione);
            $analisiSeo    = eseguiAnalisiSeoCategoria($datiCategoria);
            $categoria->setPunteggioSeo($analisiSeo["esitoTesto"]);
            echo $categoria->crea();
            break;
        case 'modifica':
            $titoloPagina = filter_input(INPUT_POST,"titoloPagina",FILTER_SANITIZE_ADD_SLASHES);
            $metaDescrizione = filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_ADD_SLASHES);
            $descrizione     = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);    
            
            $categoria->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $categoria->setAlias(filter_input(INPUT_POST,"alias",FILTER_SANITIZE_ADD_SLASHES));
            $categoria->setTitoloPagina($titoloPagina);
            $categoria->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES));
            $categoria->setCategoriaMadre(filter_input(INPUT_POST,"categoriaMadre",FILTER_SANITIZE_NUMBER_INT));
            $categoria->setElementiPerPagina(filter_input(INPUT_POST,"numeroArticoliPerPagina",FILTER_SANITIZE_NUMBER_INT));
            $categoria->setMetaDescrizione($metaDescrizione);
            $categoria->setCssAggiuntivo(filter_input(INPUT_POST,"cssAggiuntivo",FILTER_SANITIZE_ADD_SLASHES));
            $categoria->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $categoria->setOrdinamento(filter_input(INPUT_POST,"ordinamento",FILTER_SANITIZE_STRING));
            
            // calcolo puntegigo SEO
            $datiCategoria = array("titoloPagina"=>$titoloPagina,"metaDescrizione"=>$metaDescrizione,"descrizione"=>$descrizione);
            $analisiSeo    = eseguiAnalisiSeoCategoria($datiCategoria);
            $categoria->setPunteggioSeo($analisiSeo["esitoTesto"]);
            
            $categoria->modifica();
            echo "ok";
            break;
        case 'duplica':
            $categoria->caricaDatiDalDatabase();
            $idCategoriaDuplicata = $categoria->duplica();
            header("Location: $percorsoGeecomCMS/creaCategoria.php?id=$idCategoriaDuplicata&status=210");
            break;
        case 'traduci':
            $lingua = filter_input(INPUT_GET, "lingua",FILTER_SANITIZE_STRING);
            $idCategoriaTradotta = $categoria->traduci($lingua);
            header("Location: $percorsoGeecomCMS/creaCategoria.php?id=$idCategoriaTradotta&status=320");
            break;
        case 'aggiornaPosizione':
            $categoria->caricaDatiDalDatabase();
            $nuovaPosizione = filter_input(INPUT_POST,"nuovaPosizione",FILTER_SANITIZE_NUMBER_INT);
            $categoria->aggiornaPosizione($nuovaPosizione);
            echo "ok";
            break;
        case 'recuperaFotoCategoria':
            $categoria->caricaDatiDalDatabase();
            echo ($categoria->getFoto()!="" ? "../".$categoria->getFoto() : "../immagini/altro/segnaposto.png");
            break;
        case 'cambiaImmagine':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/categorie", 0, $categoria->getNome());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $categoria->cambiaImmagine($percorsoFoto);
            echo $percorsoFoto;
            break;
        case 'eliminaImmagine':
            $categoria->cambiaImmagine("");
            echo "ok";
            break;
        case 'modificaImmagineInEvidenzaConPercorso':
            $percorsoFoto = filter_input(INPUT_POST,"percorso",FILTER_SANITIZE_STRING);
            $categoria->cambiaImmagine($percorsoFoto);
            echo "ok";
            break;
        case 'elimina':
            $categoria->elimina();
            echo "ok";
            break;
        case 'spostaCategoria':
            $categoria->caricaDatiDalDatabase();
            $posizione = filter_input(INPUT_POST,"posizione",FILTER_SANITIZE_NUMBER_INT);
            $categoria->sposta($posizione);
            echo "ok";
            break;
        case 'stampaComponentiContenuto':
            $categoria->caricaDatiDalDatabase();
            $tipoElemento = filter_input(INPUT_POST,'tipoElemento',FILTER_SANITIZE_ADD_SLASHES);
            $categoria->stampaComponentiContenuto($tipoElemento);
            break;
        case 'modificaOpzioniSezione':
            $id             = filter_input(INPUT_POST,'idSezioneDaModificare',FILTER_SANITIZE_NUMBER_INT);
            $idSezione      = filter_input(INPUT_POST,'idSezione',FILTER_SANITIZE_ADD_SLASHES);
            $classeSezione  = filter_input(INPUT_POST,'classeSezione',FILTER_SANITIZE_ADD_SLASHES);
            $margineSezione = filter_input(INPUT_POST,'margineSezione',FILTER_SANITIZE_ADD_SLASHES);
            $paddingSezione = filter_input(INPUT_POST,'paddingSezione',FILTER_SANITIZE_ADD_SLASHES);
            $aTuttaLarghezza= filter_input(INPUT_POST,'sezioneATuttaLarghezza',FILTER_SANITIZE_ADD_SLASHES);
            $coloreSfondo   = filter_input(INPUT_POST,'coloreSfondo',FILTER_SANITIZE_ADD_SLASHES);
            
            if(isset($_FILES['file'])) {

                if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $modificaTesto ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
                    $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/altro/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFile  = str_replace("../","",$esitoUpload["percorso"]);
                        
                        // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                        if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                            $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                            if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                            }
                        }
                    }
                    else {
                        $percorsoFile = "";
                    }
                }
            }
            
            if(isset($_FILES['video'])) {
                if($_FILES['video']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                    $percorsoFileVideo ="";
                }
                else { //se c'è l'immagine viene salvata e inserita nel percorso foto (o audio)
                    $tipiFileAmmessi = array("video/mp4","video/ogg","video/webm");
                    $gestoreUpload = new GestoreUpload("video", $tipiFileAmmessi, 8, "../file/video/", 0, "");
                    $esitoUpload  = $gestoreUpload->salvaFile();
                    if($esitoUpload["percorso"]!="") {
                        $percorsoFileVideo  = str_replace("../","",$esitoUpload["percorso"]);
                    }
                    else {
                        $percorsoFileVideo = "";
                    }
                }
            }
            
            $categoria->modificaOpzioniSezioneComponente($id, $idSezione, $classeSezione, $aTuttaLarghezza, $margineSezione, $paddingSezione,$coloreSfondo,$percorsoFile,$percorsoFileVideo);
            $categoria->aggiornaCssGenerato();
            
            header("Location: $percorsoGeecomCMS/creaCategoria.php?id={$categoria->getId()}&status=360");
            break;
        case 'stampaCategorie':
            $tipo = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING);
            $elementiPerPagina = 25;
            $parametriRicerca = array("tipo"=>$tipo,"categoriaMadre"=>0);
            
            $parametri = array("tabella"=>"geec_categorie", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);

            $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneCategorie.php");
            $ricerca->setOrdinamento(" ORDER BY posizione ASC");

            $colonne = array("ID","Lingua","Nome","Numero articoli","Visualizzazioni totali","SEO","Posizione","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);

            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"]);
            }
            else {
                $ris = $ricerca->eseguiRicerca(1);
            }
            
            $tabella->setTipo("normale");
            while($categoria = $ris->fetch_assoc()) {
                $urlCategoria  = GeneratoreUrl::creaUrlCategoria($categoria, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                $dataCreazione = date("d/m/Y",strtotime($categoria["dataCreazione"]));
                $nomeEscape    = filter_var($categoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $posizionePrecedente = ($categoria["posizione"]<=1) ? 1 : $categoria["posizione"] - 1;
                $posizioneSuccesiva  = $categoria["posizione"] +1;
                $azioni = ["visualizza"=>$urlCategoria,"spostaSu"=>"spostaCategoria({$categoria["id"]},$posizionePrecedente)","spostaGiu"=>"spostaCategoria({$categoria["id"]},$posizioneSuccesiva)","modifica"=>"creaCategoria.php?id={$categoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$categoria["id"]},'{$nomeEscape}')"];

                if($categoria["punteggioSeo"]=="scadente") {                                            
                    $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                }
                else if($categoria["punteggioSeo"]=="discreta") {
                    $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                }
                else if($categoria["punteggioSeo"]=="buona") {
                    $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                }
                else {
                    $stringaPunteggioSEO = "";
                }

                $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                        <input type=\"number\" id=\"nuovaPosizioneCategoria{$categoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$categoria["posizione"]}\">
                        <div class=\"input-group-append\">
                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$categoria["id"]})\">Salva</button>
                        </div>
                    </div>
                </form>";

                $queryNumArticoli = "SELECT COUNT(*) FROM geecB_contenuti WHERE categoria={$categoria["id"]} OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$categoria["id"]})";
                $risNumArticoli = $geecomDb->eseguiQueryLettura($queryNumArticoli);
                $numeroArticoli = $risNumArticoli->fetch_array(MYSQLI_NUM);

                $visualizzazioniTotali   = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$categoria["id"]));
                if(!is_numeric($visualizzazioniTotali)) {
                    $visualizzazioniTotali = 0;
                }

                $tabella->aggiungiNuovaRiga(array($categoria["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($categoria["lingua"])."\">","<a href=creaCategoria.php?id={$categoria["id"]}><b>{$categoria["nome"]}</b></a><span class=\"d-block text-muted\">$urlCategoria</span>",$numeroArticoli[0],$visualizzazioniTotali,$stringaPunteggioSEO,$formPosizione),$azioni);

                // cerco e stampo eventuali sottocategorie
                $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                $risSottoCategorie   = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                    $urlSottoCategoria  = GeneratoreUrl::creaUrlCategoria($sottoCategoria, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                    $dataCreazione = date("d/m/Y",strtotime($sottoCategoria["dataCreazione"]));
                    $nomeEscape          = filter_var($sottoCategoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    $posizionePrecedente = ($sottoCategoria["posizione"]<=1) ? 1 : $sottoCategoria["posizione"] - 1;
                    $posizioneSuccesiva  = $sottoCategoria["posizione"] +1;
                    $dataCreazione = date("d/m/Y",strtotime($sottoCategoria["dataCreazione"]));
                    $azioni = ["visualizza"=>$urlSottoCategoria,"spostaSu"=>"spostaCategoria({$sottoCategoria["id"]},$posizionePrecedente)","spostaGiu"=>"spostaCategoria({$sottoCategoria["id"]},$posizioneSuccesiva)","modifica"=>"creaCategoria.php?id={$sottoCategoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$sottoCategoria["id"]},'{$nomeEscape}')"];
                    
                    $numeroArticoliSottoCategoria = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","categoria"=>$sottoCategoria["id"]));

                    $visualizzazioniTotaliSottoCategoria = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$sottoCategoria["id"]));
                    if(!is_numeric($visualizzazioniTotaliSottoCategoria)) {
                        $visualizzazioniTotaliSottoCategoria = 0;
                    }

                    if($sottoCategoria["punteggioSeo"]=="scadente") {                                            
                        $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                    }
                    else if($sottoCategoria["punteggioSeo"]=="discreta") {
                        $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                    }
                    else if($sottoCategoria["punteggioSeo"]=="buona") {
                        $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                    }
                    else {
                        $stringaPunteggioSEO = "";
                    }

                    $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                        <div class=\"input-group input-group-sm d-flex align-items-center\">
                            <input type=\"number\" id=\"nuovaPosizioneCategoria{$sottoCategoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$sottoCategoria["posizione"]}\">
                            <div class=\"input-group-append\">
                                <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$sottoCategoria["id"]})\">Salva</button>
                            </div>
                        </div>
                    </form>";

                    $tabella->aggiungiNuovaRiga(array($sottoCategoria["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($categoria["lingua"])."\">","<a href=creaCategoria.php?id={$sottoCategoria["id"]}><b> - {$sottoCategoria["nome"]}</b></a><span class=\"d-block text-muted\">$urlSottoCategoria</span>",$numeroArticoliSottoCategoria,$visualizzazioniTotaliSottoCategoria,$stringaPunteggioSEO,$formPosizione),$azioni);

                    // cerco e stampo eventuali sottocategorie della sottocategoria
                    $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                    $risSottoCategorieSottoCategorie= $geecomDb->eseguiQueryLettura($querySottoCategorie);
                    while($sottoCategoriaDellaSottoCategoria = $risSottoCategorieSottoCategorie->fetch_assoc()) {
                        $urlSottoCategoriaDellaSottoCategoria  = GeneratoreUrl::creaUrlCategoria($sottoCategoria, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                        $dataCreazione = date("d/m/Y",strtotime($sottoCategoriaDellaSottoCategoria["dataCreazione"]));
                        $azioni = ["visualizza"=>$urlSottoCategoriaDellaSottoCategoria,"spostaSu"=>"#","spostaGiu"=>"#","modifica"=>"creaCategoria.php?id={$sottoCategoriaDellaSottoCategoria["id"]}","elimina"=>"apriPopupEliminaCategoria({$sottoCategoriaDellaSottoCategoria["id"]},'{$sottoCategoriaDellaSottoCategoria["nome"]}')"];

                        $numeroArticoliSottoCategoria = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","categoria"=>$sottoCategoriaDellaSottoCategoria["id"]));

                        $visualizzazioniTotaliSottoCategoria = $geecomDb->sommaValoriColonna("numeroVisite", "geecB_contenuti", array("categoria"=>$sottoCategoriaDellaSottoCategoria["id"]));
                        if(!is_numeric($visualizzazioniTotaliSottoCategoria)) {
                            $visualizzazioniTotaliSottoCategoria = 0;
                        }

                        if($sottoCategoria["punteggioSeo"]=="scadente") {                                            
                            $stringaPunteggioSEO = "<i class=\"far fa-frown text-danger\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"scadente\"></i>";
                        }
                        else if($sottoCategoria["punteggioSeo"]=="discreta") {
                            $stringaPunteggioSEO = "<i class=\"far fa-meh text-warning\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"discreta\"></i>";
                        }
                        else if($sottoCategoria["punteggioSeo"]=="buona") {
                            $stringaPunteggioSEO = "<i class=\"far fa-smile text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"buona\"></i>";
                        }
                        else {
                            $stringaPunteggioSEO = "";
                        }

                        $formPosizione = "<form class=\"d-inline-flex mr-sm-1\">
                            <div class=\"input-group input-group-sm d-flex align-items-center\">
                                <input type=\"number\" id=\"nuovaPosizioneCategoria{$sottoCategoriaDellaSottoCategoria["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$sottoCategoriaDellaSottoCategoria["posizione"]}\">
                                <div class=\"input-group-append\">
                                    <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaCategoriaInput({$sottoCategoriaDellaSottoCategoria["id"]})\">Salva</button>
                                </div>
                            </div>
                        </form>";

                        $tabella->aggiungiNuovaRiga(array($sottoCategoriaDellaSottoCategoria["id"],"<img class=\"bandiera\" src=\"../".percorsoImmagineBandiera($categoria["lingua"])."\">","<a href=creaCategoria.php?id={$sottoCategoriaDellaSottoCategoria["id"]}><b> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</b></a><span class=\"d-block text-muted\">$urlSottoCategoriaDellaSottoCategoria</span>",$numeroArticoliSottoCategoria,$visualizzazioniTotaliSottoCategoria,$stringaPunteggioSEO,$formPosizione),$azioni);
                    }
                }
            }
            $tabella->stampa("rigaCategoria", 0);
            break;
    }